//
//  OTBase.h
//  GSFontTools
//
//  Created by Georg Seifert on 26.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "TTable.h"


@class OTTableStack;
@class OTValueRecord;
@class OTDevice;

@interface OTTableReader : NSObject {
	NSData * _data;
	NSString* _tableType;
	NSUInteger _offset;
	NSUInteger _pos;
	NSMutableArray* _valueFormat;
	id _cachingStats;
}
@property (readonly, nonatomic) NSData * data;
@property (nonatomic) NSUInteger pos;
@property (nonatomic) NSUInteger offset;
@property (nonatomic, retain) NSMutableArray *valueFormat;

- (id) initWithData:(NSData*)Data tableTag:(NSString*)TableType ;
- (id) initWithData:(NSData*)Data tableTag:(NSString*)TableType offset:(NSUInteger) Offset valueFormat:(id)ValueFormat cachingStats:(id)CachingStats ;
- (NSString*) tableType ;
- (OTTableReader*) subReader:(NSUInteger) Offset;
- (uint16_t) readUShort ;
- (int16_t) readShort ;
- (uint32_t) readULong ;
- (int32_t) readLong ;
- (NSString*) readTag ;
- (void) setValueFormat:(NSUInteger)format which:(BOOL)which ;

- (OTValueRecord*) valueRecord:(int) Which font:(TTFont*)Font ;
@end

@interface OTTableWriter : NSObject <NSCopying> {
	OTTableWriter *__unsafe_unretained _parent;
	NSMutableArray * _items;
	id _tableType;
	NSMutableArray * _valueFormat;
	NSUInteger _pos;
	BOOL _sortCoverageLast;
	NSUInteger _repeatIndex;
	NSString *_name;
}
@property (nonatomic, unsafe_unretained) OTTableWriter *parent;
@property (nonatomic, retain) NSMutableArray *items;
@property (nonatomic, retain) id tableType;
@property (nonatomic, retain) NSMutableArray *valueFormat;
@property (nonatomic) NSUInteger pos;
@property (nonatomic) BOOL sortCoverageLast;
@property (nonatomic) NSUInteger repeatIndex;
@property (nonatomic, retain) NSString *name;

- (id) initWithTableType:(id)TableType valueFormat:(NSArray*)ValueFormat ;

- (OTTableWriter *)subWriter;
- (NSData*)allData;
- (void)writeUShort:(NSUInteger)Value;
- (void)writeShort:(NSInteger)Value;
- (void)writeLong:(NSInteger)Value;
- (void)writeULong:(NSUInteger)Value;
- (void)writeTag:(NSString *)Tag;
- (void)writeSubTable:(OTTableWriter *)SubWriter;
- (void)writeCountReference:(id)Table name:(NSString *)Name;
- (void)writeStruct:(int)Format values:(NSArray *)Value;
- (void)writeData:(NSData *)Data;
- (void)setValueFormat:(int)Format which:(int)Which;
@end

@interface OTTableStack :NSObject {
	NSMutableArray* _stack;
}
@property (readonly, nonatomic) NSArray* stack;

- (void) push:(NSDictionary*) Table ;
- (void) pop ;
- (NSDictionary*) top ;
- (id) getValue:(NSString*) Name ;
- (void) storeValue:(id) Value forKey:(NSString*) Name ;

- (NSDictionary*) _findTable:(NSString*) Name;
@end

@interface OTBaseTable : NSObject {
	NSUInteger _compileStatus;
	NSUInteger _recurse;
//	NSString * _start;
//	NSString * _end;
	OTTableReader * _reader;
	TTFont * _font;
	NSArray * _converters;
	//NSMutableDictionary * _converterByName;
	NSMutableDictionary * __rawTable;
	NSInteger _format;
	NSString * _name;
}

@property (readonly, nonatomic) NSArray * converters;
@property (nonatomic) NSInteger format;
@property (retain, nonatomic) NSString * name;
@property (nonatomic) NSUInteger compileStatus;
@property (retain, nonatomic) OTTableReader * reader;
@property (retain, nonatomic) TTFont * font;
//@property (retain, nonatomic) NSString *  start;
//@property (retain, nonatomic) NSString *  end;

//- (BOOL) decompile:(OTTableReader*)Reader font:(TTFont*)Font error:(NSError**)error;
- (Class) lookupListClass ;
- (BOOL) decompile:(OTTableReader*)Reader font:(TTFont*)Font tableStack:(OTTableStack*) aTableStack error:(NSError**) error ;

- (void) preCompile ;
- (void) compile:(OTTableWriter*)Writer font:(TTFont*)Font tableStack:(OTTableStack *)TableStack ;
- (void) readFormat:(OTTableReader*) Reader ;
- (void) writeFormat:(OTTableWriter*) Writer ;

- (void) postRead:(NSDictionary*) Table font:(TTFont*)Font ;
- (NSMutableDictionary*) preWrite:(TTFont*)Font ;
- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*)Font attrs:(id) Attrs; 
- (void) toXML2:(GSXMLWriter*)Writer font:(TTFont*)Font;
- (void) fromXML:(NSString*)name attrs:(NSDictionary*) attrs content:(id)content font:(TTFont*)Font ;

- (NSString*) fdkFeatureCode:(NSArray*)GlyphOrder;
@end


@interface BaseTTXConverter : TTable {
	//NSString * _tableTag;
	OTBaseTable * _table;
}
@property (retain, nonatomic) OTBaseTable * table;
@end


@interface OTFormatSwitchingBaseTable : OTBaseTable {
	//NSUInteger _format;
}
//@property (nonatomic) NSUInteger format;
@end


@interface ValueRecordFactory : NSObject <NSCopying> {
	NSMutableArray * _format;
}
- (void) setFormat:(unsigned short) ValueFormat;
- (OTValueRecord*) readValueRecord:(OTTableReader*)Reader font:(TTFont*)Font;
@end


@interface OTValueRecord : NSObject {
	OTDevice * _xPlaDevice;
	OTDevice * _yPlaDevice;
	OTDevice * _xAdvDevice;
	OTDevice * _yAdvDevice;
@public
	NSInteger xPlacement;
	NSInteger yPlacement;
	NSInteger xAdvance;
	NSInteger yAdvance;
}
@property (nonatomic, strong) OTDevice* xPlaDevice;
@property (nonatomic, strong) OTDevice* yPlaDevice;
@property (nonatomic, strong) OTDevice* xAdvDevice;
@property (nonatomic, strong) OTDevice* yAdvDevice;
@end

@interface valueRecordFormat : NSObject {
	NSString * _name;
@public
	uint16_t Mask;
	BOOL isDevice;
	BOOL isSigned;
}
@property (nonatomic, retain) NSString* name;
@end
